<?php

namespace App\Http\Controllers;

use App\Transaction;
use App\TransactionComment;
use Illuminate\Http\Request;

class TransactionCommentController extends Controller
{
    public function index($transactionId)
    {
        $business_id = request()->session()->get('user.business_id');
        $tx = Transaction::where('business_id', $business_id)->findOrFail($transactionId);

        $comments = TransactionComment::where('transaction_id', $tx->id)
            ->orderBy('created_at', 'asc')
            ->get(['id','user_first_name','user_role','comment','created_at']);

        return response()->json($comments);
    }

    public function store(Request $request, $transactionId)
    {
        $request->validate(['comment' => 'required|string']);

        $user = auth()->user();
        $business_id = request()->session()->get('user.business_id');
        $tx = Transaction::where('business_id', $business_id)->findOrFail($transactionId);

        $roleName = null;
        try {
            if (method_exists($user, 'getRoleNames')) {
                $roleName = optional($user->getRoleNames())->first();
            }
        } catch (\Throwable $e) {}

        $comment = TransactionComment::create([
            'transaction_id' => $tx->id,
            'user_id' => $user->id,
            'user_first_name' => $user->first_name ?? ($user->surname ?? ''),
            'user_role' => $roleName,
            'comment' => $request->input('comment'),
        ]);

        return response()->json([
            'id' => $comment->id,
            'user_first_name' => $comment->user_first_name,
            'user_role' => $comment->user_role,
            'comment' => $comment->comment,
            'created_at' => $comment->created_at->toDateTimeString(),
        ], 201);
    }
}

